// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-7: Dimensional Analysis, Similitude, and Modeling
//Example: 7.5 Page 372
// Title: Prediction of Prototype Performance from Model Data
//===================================================================
model Ex7_5

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real f(unit = "Hz")"Vortex shedding frequency";
Real V_m(unit = "m/s")"Velocity of the fluid in the model";
Real H_m(unit = "mm")"Height of the model";

//=============
// Parameter Section 

parameter Real D(unit = "m")=0.1"Diameter of the structure";
parameter Real D_m(unit = "m")=0.02"Diameter of the model";
parameter Real H(unit = "m")=0.3"Height of the structure";
parameter Real V(unit = "km/hr")=50"Wind Velocity";
parameter Real T(unit = "C")=20"Temperature of the model";
parameter Real f_m(unit = "Hz")=49.9"Shedding Frequency of model";
parameter Real mu_m(unit = "kg/m.s")=0.001"Viscosity of fluid used in model";
parameter Real rho_m(unit = "kg/m^3")=998"Density of fluid used in model";
parameter Real mu(unit = "kg/m.s")=0.0000179"Viscosity of air ";
parameter Real rho(unit = "kg/m^3")=1.23"Density of air";

//=============
// Equation Section 

equation

H_m = ((D_m/D)*H)*1000;//Calculation of Height of the model
//Note: Multiplication of the RHS term by 1000 to convert H_m to mm

V_m = (mu_m/mu)*(rho/rho_m)*(D/D_m)*(V*(1000/3600));//Calculation of velocity of fluid in model
//Note: Multiplication of the term V by 1000/3600 to convert to m/s

f = ((V*(1000/3600))/V_m)*(D_m/D)*f_m;//Calculation of actual vortex shedding frequency 
//Note: Multiplication of the term V by 1000/3600 to convert to m/s

end Ex7_5;
//===================================================================
