// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-7: Dimensional Analysis, Similitude, and Modeling
//Example: 7.6 Page 377
// Title: Reynolds Number Similarity
//===================================================================
model Ex7_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Q_m(unit = "ft^3/s")"Flowrate of the model";

//=============
// Parameter Section 

parameter Real D(unit = "ft")=2"Diameter of the structure";
parameter Real D_m(unit = "in")=3"Diameter of the model";
parameter Real Q(unit = "ft^3/s")=30"Actual flowrate";

//=============
// Equation Section 

equation

Q_m = ((D_m/12)/D)*Q;//Calculation of flow rate of the model
//Note: Division of D_m by 12 to convert to ft

end Ex7_6;
//===================================================================
