// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-7: Dimensional Analysis, Similitude, and Modeling
//Example: 7.7 Page 380
// Title: Model Design Conditions and Predicted Prototype Performance
//===================================================================
model Ex7_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Pr(unit = "")"Pressure ratio: model to that of prototype";
Real rhor(unit = "")"Density ratio: model to that of prototype";
Real P_m(unit ="psi")"Pressure of fluid on the model";
Real D(unit = "lb")"Drag on the prototype";

//=============
// Parameter Section 

parameter Real P(unit = "psi")=14.7"Pressure of the fluid in prototype";
parameter Real D_m(unit = "lb")=1"Drag on the model";
parameter Real lr(unit = "")=10"Length ratio: Prototype to that of model";
parameter Real Vr(unit = "")=1"Velocity ratio: Prototype to that of model";
parameter Real mur(unit = "")=1"Viscosity ratio: Prototype to that of model";

//=============
// Equation Section 

equation

rhor = (Vr*lr)/mur;//Calculation of Density ratio: model to that of prototype

Pr = rhor; //Calculation of Pressure ratio: model to that of prototype

P_m = Pr*P; //Calculation of Pressure of fluid on the model

D = ((Vr*lr)^2*D_m)/rhor; //Calculation of drag on the prototype

end Ex7_7;
//===================================================================
