// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.10 Page 451
// Title: Type II, Determine Flowrate
//===================================================================
model Ex8_10

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V2(unit ="ft/s")"Velocity of fluid at section 2";
Real h_p(unit = "ft")"Pressure head";
Real h_l(unit = "ft")"Minor loss";
Real f(unit = "")"Friction factor";
Real V(unit = "ft/s")"Velocity of fluid after remodelling";
Real Q_m(unit = "ft^3/s")"flowrate of fluid after remodelling";

//=============
// Parameter Section 

parameter Real SW(unit = "lb/ft^3")=0.0765"Specific weight of air";
parameter Real Q(unit = "ft^3/s")=9"Flow rate of fluid";
parameter Real l(unit = "ft")=100"Total length of pipe";
parameter Real D(unit = "in")=8"Diameter of pipe";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
 final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real Kl(unit = "")=5"Minor Loss coefficient";
parameter Real Klm(unit = "")=10"Minor Loss coefficient after remodelling";


//=============
// Equation Section 

equation

V2 = Q/((pi/4)*(D/12)^2);//Calculation of velocity of fluid in section 2
//Note: Division of term D by 12 to convert to ft

h_l = (Kl*V2^2)/(2*g);//Calculation of minor loss

h_p = ((V2^2) /(2*g))+ h_l;//calculation of pressure head

f = 0.017;//Calculation of friction factor
//Note: The above value is obtained from Moody chart

V = sqrt((2*g*h_p)/(1 + (f*(l/(D/12))) + Klm));//Calculation of velocity of fluid after remodelling
//Note: Division of term D by 12 to convert to ft

Q_m = V*((pi/4)*(D/12)^2);//Calculation of flowrate of fluid after remodelling
//Note: Division of term D by 12 to convert to ft

end Ex8_10;
//===================================================================
//The answer slightly varies (2.72% deviation) due  to rounding off values
