// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.11 Page 453
// Title: Type II, Determine Flowrate
//===================================================================
model Ex8_11

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real ht(unit = "ft")"Turbine head";
Real hl(unit = "ft")"Head loss";
Real V(unit = "ft/s")"Velocity of fluid";
Real Q(unit = "ft^3/s")"Flow rate";

//=============
// Parameter Section 

parameter Real l(unit ="ft")=300 "Length of the pipe";
parameter Real D(unit = "ft")=1 "Diameter of the pipe";
parameter Real f(unit = "")=0.02"Friction Factor";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real z(unit = "ft")=90"Height of water surface from turbine";
parameter Real SW(unit ="lb/ft^3")=62.4"Specific weight of water";
parameter Real P(unit = "hp")=50"Power of the turbine";

//=============
// Equation Section 

equation

hl = (f*(l/D)*(V^2/(2*g)));//Calculation of head loss

ht = ((P*550)/(SW*Q));//Calculation of head of the turbine

z = ((V^2)/(2*g)) + hl + ht;//Calculation of velocity of fluid

Q = ((pi/4)*D^2)*V;//Calculation of flow rate

end Ex8_11;
//===================================================================
