// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.14 Page 458
// Title: Three-Reservoir, Multiple Pipe System
//===================================================================
model Ex8_14

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V1(unit = "ft/s")"Velocity of fluid in pipe 1";
Real V2(unit = "ft/s")"Velocity of fluid in pipe 2";
Real V3(unit = "ft/s")"Velocity of fluid in pipe 3";
Real Q1(unit = "ft^3/s")"Flowrate of fluid in pipe 1";
Real Q2(unit = "ft^3/s")"Flowrate of fluid in pipe 2";
Real Q3(unit = "ft^3/s")"Flowrate of fluid in pipe 3";

//=============
// Parameter Section 

parameter Real za(unit = "ft")=100"Elevation of pt. A";
parameter Real zb(unit = "ft")=20"Elevation of pt. B";
parameter Real zc(unit = "ft")=0"Elevation of pt. C";
parameter Real D(unit = "ft")=1"Diameter of pipe 1,2,3";
parameter Real l1(unit ="ft")=1000"Length of pipe 1";
parameter Real l2(unit ="ft")=500"Length of pipe 2";
parameter Real l3(unit ="ft")=400"Length of pipe 3";
parameter Real f(unit = "")=0.02"Friction factor";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation

V1 = V2+V3;//Solving continuity equation

za = zb + (f/(2*D*g))*((l1*V1^2)+(l2*V2^2));//Solving energy equation between point A and B

za = zc + (f/(2*D*g))*((l1*V1^2)+(l3*V3^2));//SOlving energy equation between point A and C

Q1 = ((pi/4)*D^2)*V1;//Calculation of flowrate of fluid in pipe 1 

Q2 = ((pi/4)*D^2)*V2;//Calculation of flowrate of fluid in pipe 2

Q3 = Q1 - Q2;//Calculation of flowrate of fluid in pipe 3

end Ex8_14;
//===================================================================
