model Ex8_3_b
  // Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016
  //Chapter-8: Viscous Flow in Pipes
  //Example: 8.3.b Page 416
  // Title: Laminar Pipe Flow Properties
  //===================================================================
  //===============
  // Libraries
  extends Modelica.Constants;
  //=============
  // Variable Section
  Real P(unit = "lb/ft^2") "Pressure drop";
  Real V(unit = "ft/s") "Velocity of fluid";
  Real T_w(unit = "lb/ft^2") "wall shear stress";
  Real F_p(unit = "lb") "Pressure force";
  Real F_v(unit = "lb") "Viscous force";
  //=============
  // Parameter Section
  parameter Real mu(unit = "lb.s/ft^2") = 0.0038 "Viscosity of fluid";
  parameter Real D(unit = "in") = 3 "Diameter of the pipe";
  parameter Real l(unit = "ft") = 6 "Length of the pipe";
  parameter Real Q(unit = "ft^3/s") = 0.5 "Volume flow rate";
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  //=============
  // Equation Section
equation
  P = 128 * mu * l * Q / (pi * (D / 12) ^ 4);
//Calculation of pressure drop
//Note: Division of the term D by 12 to convert to ft
  V = Q / (pi / 4 * (D / 12) ^ 2);
//Calculation of velocity of fluid
//Note: Division of the term D by 12 to convert to ft
  T_w = P * (D / 12) / (4 * l);
//Calculation of wall shear stress
//Note: Division of the term D by 12 to convert to ft
  F_p = pi / 4 * (D / 12) ^ 2 * P;
//Calculation of net pressure force
//Note: Division of the term D by 12 to convert to ft
  F_v = 2 * pi * (D / 2 / 12) * l * T_w;
//Calculation of net viscous force
//Note: Division of the term D/2 by 12 to convert to ft
end Ex8_3_b;
