// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.11 Page 525
// Title: Terminal Velocity of a Falling Object
//===================================================================
model Ex9_11

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real C_d(unit = "")"Drag coefficient";
Real U(unit = "mph")"Velocity of updraft";

//=============
// Parameter Section
 
parameter Real rho_ice(unit = "slug/ft^3")=1.84"Density of ice";
parameter Real rho_air(unit = "slug/ft^3")=0.00238"Density of air";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real D(unit = "ft")=0.125"Diameter";

//=============
// Equation Section 

equation

C_d = 0.5;//Calculation of discharge coefficient
//Note: The value is obtained from Fig. 9.23 in Page No. 524

U = sqrt((4*rho_ice*g*D)/(3*rho_air*C_d))*0.681818;//Calculation of velocity of updraft
//Note: The expression is ultiplied by 0.681818 to conver U to mph

end Ex9_11;
//===================================================================
