// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.13 Page 530
// Title: Drag on a Composite Body
//===================================================================
model Ex9_13

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real M(unit = "ft.lb")"Required moment";
Real Ds(unit = "lb")"Drag force of sphere";
Real Dc(unit = "lb")"Drag force of cylinder";

//=============
// Parameter Section
 
parameter Real rho(unit = "slug/ft^3")=0.00238"Density of air";
parameter Real U(unit = "ft/s")=88"Velocity of wind"; 
parameter Real w(unit = "ft")=50"Height of the cylinder";
parameter Real D_s(unit = "ft")=40"Diameter of sphere"; 
parameter Real D_c(unit = "ft")=15"Diameter of cylinder";
parameter Real Cds(unit = "")=0.3"Drag coefficient of sphere";
parameter Real Cdc(unit = "")=0.7"Drag coefficient of cylinder";

//=============
// Equation Section 

equation

Ds = ((1/2)*rho*(U^2)*((pi/4)*(D_s)^2)*Cds);//Calculation of drag force on the sphere

Dc = ((1/2)*rho*(U^2)*(D_c*w)*Cdc);//Calculation of drag force on the cylinder

M = (Ds*(w+(D_s/2))) + (Dc*(w/2));//Calculation of moment

end Ex9_13;
//===================================================================
