// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-9: General External Flow Characteristics
//Example: 9.15 Page 540
// Title: Lift and Power for Human-Powered Flight
//===================================================================
model Ex9_15

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Cl(unit = "ft.lb")"Lift Coefficint";
Real P(unit = "hp")"Power required by pilot";

//=============
// Parameter Section
 
parameter Real rho(unit = "slug/ft^3")=0.00238"Density of air";
parameter Real U(unit = "ft/s")=15"Flight speed"; 
parameter Real b(unit = "ft")=96"Wing size";
parameter Real C(unit = "ft")=7.5"Average chord length";
parameter Real w(unit = "lb")=210"Weight of airplane";
parameter Real Cd(unit = "")=0.046"Drag coefficient";
parameter Real Eff(unit = "")=0.8"Power terrain efficiency";

//=============
// Equation Section 

equation

Cl = (2*w)/(rho*(U)^2*(b*C));//Calculation of lift coefficient

P = ((rho*(b*C)*Cd*(U)^3)/(2*Eff))/550;//Calculation of power required by the pilot
//Note: The expression is divided by 550 to convert P to hp unit

end Ex9_15;
//===================================================================
