//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.1 Page 13
//Title:  Surface Mean Diameter
//======================================================

model Ex1_1
extends Modelica.Math; 

//=============
// Parameter Section
 
parameter Real x[2] ={0,1} " Mass fraction";
parameter Real d[2](each unit="micro m") ={1,101} " Mass fraction";

//From figure 1.7 on pg 14, we get d=100x+1

//=============
// Variable Section

Real ds(unit="micro m") " Surface mean diameter";

//=============
// Equation Section

equation

ds=100/( (log((100*x[2])+1)) -(log((100*x[1])+1)));

end Ex1_1;
//===============
