//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.5 Page 71
//Title:  Efficiency of collection of dust
//======================================================

model Ex1_5

//=============
// Parameter Section
 
parameter Real basis(unit="kg") =100" Basis";
parameter Real n[3]={45,80,96} " Efficiency(per cent) for 3 size ranges ";
parameter Real m[3] ={50,30,20} " Mass percent"; 

//=============
// Variable Section


Real mi[3](each unit="kg") " Mass inlet";
Real mr[3](each unit="kg") " Mass retained";
Real n_ovr(unit="") " Overall Efficiency";

//=============
// Equation Section

equation

for i in 1:3 loop
mi[i]=basis*m[i]/100;
mr[i]=mi[i]*n[i]/100;
end for;

n_ovr=100*(mr[1]+mr[2]+mr[3])/basis;


end Ex1_5;
//===============
