//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-10: Leaching
//Example: 10.4 Page 536
//Title:  Number of ideal stages required
//======================================================

model Ex10_4

//=============
// Parameter Section
 
parameter Real xAo=0.2 " Mole fraction in seed";
parameter Real yA1=0.5 " Mole fraction in final solution";
parameter Real x[3]={0.0167,0.6667,0.3166} " Mole fraction "; //When 1 kg of insoluble solid in the washed product is associated with 0.5 kg of solution and 0.025 kg oil

//=============
// Variable Section

Real xBo " Mole fraction in seed";
Real yS1 " Mole fraction in final solution";
Real No " No of thickeners";

//=============
// Equation Section

equation

//The mass fraction of insoluble material in the underflow is constant and equal to 0.667. The composition of the underflow is therefore represented, on the diagram Figure 10.22, by a straight line parallel to the hypotenuse of the triangle with an intercept of 0.333 on the two main axes.

xBo+xAo=1;
yA1+yS1=1;

//The graphical construction described in the text is then used and it is seen from Figure 10.22 that xn lies in between x4 and x5
No=5;//Thus 5 thickeners are adequate and for the required degree of extraction

end Ex10_4;
//===============
