//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.10 Page 587
//Title:   Boiler and Condenser Duty
//======================================================

model Ex11_10

//=============
// Parameter Section
 
parameter Real F(unit="kg/s")=1 " Feed";
parameter Real xd=0.995 " Percentage purity at distillate";
parameter Real xw=0.1 " Percentage at bottoms";
parameter Real xf=0.3 " Percentage of feed";
parameter Real Pe=0.6 " Plate efficiency";
parameter Real N=5 " Number of plates"; //Obtained from the Fig11.29 
parameter Real QbW=791 " Ratio of Qb:W "; // Obtained from the Fig11.29 

//=============
// Variable Section

Real D(unit="kg/s") " Distillate";
Real W(unit="kg/s") " Bottoms";
Real Rm " Minimum reflux ratio";
Real Np " Number of plates to be provided";
Real Hb(unit="kW") " Heat duty to boiler";
Real Hc(unit="kW") " Heat duty to condenser";

//=============
// Equation Section

equation

F=D+W;
F*xf=(D*xd)+(W*xw);
Rm=(1952-1547)/(1547-295);
Np=N/Pe;
Hb=QbW*W;
Hc=(1984-296)*D;

end Ex11_10;
//===============
