//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.11 Page 590
//Title:   Number of theoretical stages
//======================================================

model Ex11_11

//=============
// Parameter Section
 
parameter Real F(unit="kg")=100 " Basis of Feed";
parameter Real S(unit="kg")=10 " Amount of side stream";
parameter Real xs=0.8 " Percentage purity at side stream";
parameter Real xd=0.95 " Percentage purity at distillate";
parameter Real xw=0.05 " Percentage at bottoms";
parameter Real xf=0.5 " Percentage of feed";
parameter Real R=2.5 " Reflux ratio";

//=============
// Variable Section

Real D(unit="kg") " Distillate";
Real W(unit="kg") " Bottoms";
Real N " Number of theoretical stages ";

//=============
// Equation Section

equation

F=D+W+S;
F*xf=(D*xd)+(W*xw)+(S*xs);
N=13; // From the figure 11.32 we get Number of theoretical stages

end Ex11_11;
//===============
