//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.14 Page 601
//Title:   Number of ideal plates and approximate product composition
//======================================================

model Ex11_14
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real F(unit="kmol/h")=100 " Basis of Feed";
parameter Real xf[3]={0.6,0.04,0.36} " Value of xf";
parameter Real xd[3]={0.98,0.006,0.014} " Compositon of xd of ortho isomer";
parameter Real xwo=0.125 " Composition of xd of ortho isomer";
parameter Real a[3]={1.7,1.16,1} " Relative volatility wrt para isomer";

//=============
// Variable Section

Real D(unit="kmol/h")  " Amount of Distillate";
Real W(unit="kmol/h")  " Amount of Bottoms";
Real Ln(unit="kmol/h")  " Liquid Downflow";
Real Vn(unit="kmol/h")  " Vapour Downflow";
Real Lm(unit="kmol/h")  " Liquid Downflow at boiling point";
Real Vm(unit="kmol/h")  " Vapour Downflow at boiling point";
Real xs[3] " Mole fraction";
Real axs[3] " Value of alpha xs";
Real ys[3] " Mole fraction";
Real x1[3]" Mole fraction";
Real ax1[3] " Value of alpha x1";
Real y1[3]" Mole fraction";
Real x2[3]" Mole fraction";
Real ax2[3] " Value of alpha x2";
Real y2[3]" Mole fraction";
Real x3[3]" Mole fraction";
Real ax3[3] " Value of alpha x3";
Real y3[3]" Mole fraction";
Real x4[3]" Mole fraction";
Real ax4[3] " Value of alpha x4";
Real y4[3]" Mole fraction";
Real x5[3]" Mole fraction";
Real ax5[3] " Value of alpha x5";
Real y5[3]" Mole fraction";
Real x6[3]" Mole fraction";
Real ax6[3] " Value of alpha x6";
Real y6[3]" Mole fraction";
Real x7[3]" Mole fraction";
Real ax7[3] " Value of alpha x7";
Real y7[3]" Mole fraction";
Real x8[3]" Mole fraction";
Real ax8[3] " Value of alpha x8";
Real y8[3]" Mole fraction";
Real x9[3]" Mole fraction";
Real ax9[3] " Value of alpha x9";
Real y9[3]" Mole fraction";
Real x10[3]" Mole fraction";
Real ax10[3] " Value of alpha x10";
Real y10[3]" Mole fraction";
Real x11[3]" Mole fraction";
Real ax11[3] " Value of alpha x11";
Real y11[3]" Mole fraction";
Real x12[3]" Mole fraction";
Real ax12[3] " Value of alpha x12";
Real y12[3]" Mole fraction";
Real x13[3]" Mole fraction";
Real ax13[3] " Value of alpha x13";
Real y13[3]" Mole fraction";
Real x14[3]" Mole fraction";
Real ax14[3] " Value of alpha x14";
Real y14[3]" Mole fraction";
Real x15[3]" Mole fraction";
Real ax15[3] " Value of alpha x15";
Real y15[3]" Mole fraction";
Real x16[3]" Mole fraction";
Real ax16[3] " Value of alpha x16";
Real y16[3]" Mole fraction";
Real no " Number of plates";

//=============
// Equation Section

equation

F=D+W;
F*xf[1]=D*xd[1] + W*xwo;
Ln=5*D;
Vn=6*D;
Lm=Ln+F;
Vm=Lm-W;
F*xf[1]=D*xd[1]+W*xs[1];
F*xf[2]=D*xd[2]+W*xs[2];
F*xf[3]=D*xd[3]+W*xs[3];

//Plate compositions below feed plate

for i in 1:3 loop
axs[i]=a[i]*xs[i];
end for;
for i in 1:3 loop
ys[i]=axs[i]/sum(axs);
end for;
ys[1]=(1.1333*x1[1])-0.0166;
ys[2]=(1.1333*x1[2])-0.011;
ys[3]=(1.1333*x1[3])-0.105;

for i in 1:3 loop
ax1[i]=a[i]*x1[i];
end for;
for i in 1:3 loop
y1[i]=ax1[i]/sum(ax1);
end for;
y1[1]=(1.1333*x2[1])-0.0166;
y1[2]=(1.1333*x2[2])-0.011;
y1[3]=(1.1333*x2[3])-0.105;

for i in 1:3 loop
ax2[i]=a[i]*x2[i];
end for;
for i in 1:3 loop
y2[i]=ax2[i]/sum(ax2);
end for;
y2[1]=(1.1333*x3[1])-0.0166;
y2[2]=(1.1333*x3[2])-0.011;
y2[3]=(1.1333*x3[3])-0.105;

for i in 1:3 loop
ax3[i]=a[i]*x3[i];
end for;
for i in 1:3 loop
y3[i]=ax3[i]/sum(ax3);
end for;
y3[1]=(1.1333*x4[1])-0.0166;
y3[2]=(1.1333*x4[2])-0.011;
y3[3]=(1.1333*x4[3])-0.105;

for i in 1:3 loop
ax4[i]=a[i]*x4[i];
end for;
for i in 1:3 loop
y4[i]=ax4[i]/sum(ax4);
end for;
y4[1]=(1.1333*x5[1])-0.0166;
y4[2]=(1.1333*x5[2])-0.011;
y4[3]=(1.1333*x5[3])-0.105;

for i in 1:3 loop
ax5[i]=a[i]*x5[i];
end for;
for i in 1:3 loop
y5[i]=ax5[i]/sum(ax5);
end for;
y5[1]=(1.1333*x6[1])-0.0166;
y5[2]=(1.1333*x6[2])-0.011;
y5[3]=(1.1333*x6[3])-0.105;

for i in 1:3 loop
ax6[i]=a[i]*x6[i];
end for;
for i in 1:3 loop
y6[i]=ax6[i]/sum(ax6);
end for;
y6[1]=(1.1333*x7[1])-0.0166;
y6[2]=(1.1333*x7[2])-0.011;
y6[3]=(1.1333*x7[3])-0.105;

//Plate compositions above feed plate

for i in 1:3 loop
ax7[i]=a[i]*x7[i];
end for;
for i in 1:3 loop
y7[i]=ax7[i]/sum(ax7);
end for;
y7[1]=(0.833*x8[1])+0.163;
y7[2]=(0.833*x8[2])+0.001;
y7[3]=(0.833*x8[3])+0.002;

for i in 1:3 loop
ax8[i]=a[i]*x8[i];
end for;
for i in 1:3 loop
y8[i]=ax8[i]/sum(ax8);
end for;
y8[1]=(0.833*x9[1])+0.163;
y8[2]=(0.833*x9[2])+0.001;
y8[3]=(0.833*x9[3])+0.002;

for i in 1:3 loop
ax9[i]=a[i]*x9[i];
end for;
for i in 1:3 loop
y9[i]=ax9[i]/sum(ax9);
end for;
y9[1]=(0.833*x10[1])+0.163;
y9[2]=(0.833*x10[2])+0.001;
y9[3]=(0.833*x10[3])+0.002;

for i in 1:3 loop
ax10[i]=a[i]*x10[i];
end for;
for i in 1:3 loop
y10[i]=ax10[i]/sum(ax10);
end for;
y10[1]=(0.833*x11[1])+0.163;
y10[2]=(0.833*x11[2])+0.001;
y10[3]=(0.833*x11[3])+0.002;

for i in 1:3 loop
ax11[i]=a[i]*x11[i];
end for;
for i in 1:3 loop
y11[i]=ax11[i]/sum(ax11);
end for;
y11[1]=(0.833*x12[1])+0.163;
y11[2]=(0.833*x12[2])+0.001;
y11[3]=(0.833*x12[3])+0.002;

for i in 1:3 loop
ax12[i]=a[i]*x12[i];
end for;
for i in 1:3 loop
y12[i]=ax12[i]/sum(ax12);
end for;
y12[1]=(0.833*x13[1])+0.163;
y12[2]=(0.833*x13[2])+0.001;
y12[3]=(0.833*x13[3])+0.002;

for i in 1:3 loop
ax13[i]=a[i]*x13[i];
end for;
for i in 1:3 loop
y13[i]=ax13[i]/sum(ax13);
end for;
y13[1]=(0.833*x14[1])+0.163;
y13[2]=(0.833*x14[2])+0.001;
y13[3]=(0.833*x14[3])+0.002;

for i in 1:3 loop
ax14[i]=a[i]*x14[i];
end for;
for i in 1:3 loop
y14[i]=ax14[i]/sum(ax14);
end for;
y14[1]=(0.833*x15[1])+0.163;
y14[2]=(0.833*x15[2])+0.001;
y14[3]=(0.833*x15[3])+0.002;

for i in 1:3 loop
ax15[i]=a[i]*x15[i];
end for;
for i in 1:3 loop
y15[i]=ax15[i]/sum(ax15);
end for;
y15[1]=(0.833*x16[1])+0.163;
y15[2]=(0.833*x16[2])+0.001;
y15[3]=(0.833*x16[3])+0.002;

for i in 1:3 loop
ax16[i]=a[i]*x16[i];
end for;
for i in 1:3 loop
y16[i]=ax16[i]/sum(ax16);
end for;

no=16;

// There are variations in values obtained that obtained from the book. This is because of possible truncation errors.

end Ex11_14;
//===============
