//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.17 Page 613
//Title:   Number of theoretical plates required
//======================================================

model Ex11_17
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real F[3](each unit="kmol")={40,35,25} " Feed";
parameter Real D[3](each unit="kmol")={40,34,1} " Products";
parameter Real W[3](each unit="kmol")={0,1,24} " Bottoms";
parameter Real a[3]={2.7,2.22,1} " Relative Volatility";
parameter Real xf[3]={0.4,0.35,0.25} " Mole fraction of feed";
parameter Real xd[3]={0.534,0.453,0.013} " Mole fraction of products"; 
parameter Real xw[3]={0,0.04,0.96} " Mole fraction of bottoms";

//=============
// Variable Section

Integer n " Number of theoretical plates";
Integer nr " Number of plates rounded off";

//=============
// Equation Section

equation

n+1=log10((xd[2]/xd[3])*(xw[3]/xw[2]))/log10(a[2]);
nr=n+1;

end Ex11_17;
//===============
