//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.18 Page 614
//Title:   Variation in value of n
//======================================================

model Ex11_18

//=============
// Parameter Section
 
parameter Real F[3](each unit="kmol")={40,35,25} " Feed";
parameter Real D[3](each unit="kmol")={40,34,1} " Products";
parameter Real W[3](each unit="kmol")={0,1,24} " Bottoms";
parameter Real a[3]={2.7,2.22,1} " Relative Volatility";
parameter Real xf[3]={0.4,0.35,0.25} " Mole fraction of feed";
parameter Real xd[3]={0.534,0.453,0.013} " Mole fraction of products"; 
parameter Real xw[3]={0,0.04,0.96} " Mole fraction of bottoms";
parameter Real Rm=0.83 " Minimum Reflux ratio";
parameter Real nm=7.5  " Value of minimum theoretical plates";
parameter Real R[4]={1,2,5,10} " Reflux ratio";
parameter Real y[4]={0.55,0.32,0.15,0.08} " Value of ordinate";

//=============
// Variable Section

Real x[4] " Value of abscissa";
Real n[4] " Value of n";

//=============
// Equation Section

equation

for i in 1:4 loop

x[i]=(R[i]-Rm)/(R[i]+1);
y[i]=((n[i]+1)-(nm+1))/(n[i]+2);

end for;

end Ex11_18;
//===============
