//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.19 Page 615
//Title:  Optimum reflux ratio
//======================================================

model Ex11_19

//=============
// Parameter Section
 
// Feed
parameter Real F[3](each unit="kmol") ={40,35,25}" Feed ";
parameter Real xF[3]={0.4,0.35,0.25} " Mole fraction of feed";

// Overhead
parameter Real D[3](each unit="kmol") ={40,34,1}" Distillate";
parameter Real xD[3]={0.534,0.453,0.013} " Mole fraction of distillate";

// Bottoms
parameter Real B[3](each unit="kmol") ={0,1,24}" Bottoms";
parameter Real xB[3]={0,0.04,0.96} " Mole fraction of bottoms";

parameter Real e=0.95 " Plate efficiencies";
parameter Real u(unit="kmol/m^2s")=2e-3 " Allowable vapour velocities";
parameter Real N(unit="kmol/m^2s")=1.35e-3 " Allowable vapour velocities";
parameter Real ca(unit=" Great British Pound/m^2 year plate") =400 " Incremental costs";
parameter Real cb(unit=" Great British Pound/m^2 year") =25 " Incremental costs";
parameter Real cd(unit=" Great British Pound/kmol") =0.05 " Incremental costs";
parameter Real T(unit="K")=15 " Temperature difference";

// Data from figure 11.42
parameter Real x[11]= {0 ,0.02 ,0.04 ,0.06 ,0.08 ,0.1, 0.2, 0.4, 0.6, 0.8, 1.0} " Value of x axis";
parameter Real y[11]= {0.75 ,0.62 ,0.60, 0.57 ,0.55 ,0.52 ,0.45 ,0.30 ,0.18
,0.09 ,0} " Value of y axis";

parameter Real R[9]={0.92, 1.08, 1.25 ,1.75 ,2.5, 3.5, 5.0, 7.0, 9.0} " Reflux ratio";
parameter Real n[9]={28.6, 22.8, 16.9 ,13.5, 11.7, 10.5, 9.8, 9.2 ,8.95} " Number of plates";
parameter Real dndR[9]={110.0, 34.9, 9.8 ,3.8 ,1.7 ,0.6, 0.4 ,0.2, 0.05}
"Derivative calculated from the graph";

//=============
// Variable Section

Real Rm " Minimum reflux ratio"; 
Real nm " Number of plates at total reflux";
Real Ropt " Optimum reflux ratio";

//=============
// Equation Section

equation

Rm=0.83;
nm=8;
Ropt=1.25; // The optimum value till balance was attained

end Ex11_19;
//===============
