//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.3 Page 549
//Title:  Vapour phase composition
//======================================================

model Ex11_3
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real T(unit="K")=338 " Temperature";
parameter Real Pt(unit="kPa")=101.3 " Pressure";
parameter Real kB[3]={6.90565,1211.033,220.79}" Antoine constants for Benzene";
parameter Real kT[3]={6.95334,1343.943,219.377}" Antoine constants for Toluene";
parameter Real x=0.5 " Mole fraction in the liquid phase";
 

//=============
// Variable Section

Real pB (unit="mm Hg")" Saturated vapour pressure of Benzene";
Real pT (unit="mm Hg")" Saturated vapour pressure of Toluene";
Real pBkPa (unit="kPa")" Saturated vapour pressure of Benzene in kPa";
Real pTkPa (unit="kPa")" Saturated vapour pressure of Toluene in kPa";
Real yB " Mole fraction of Benzene in vapour phase";
Real yT " Mole fraction of Toluene in vapour phase";
Real Tc(unit="C") " Temperature in Celsius";

//=============
// Equation Section

equation

Tc=T-273.15;
log10(pB)=kB[1]-(kB[2]/(kB[3]+Tc));
log10(pT)=kT[1]-(kT[2]/(kT[3]+Tc));
pBkPa=(pB/760)*101.325;
pTkPa=(pT/760)*101.325;
yB=pBkPa/(pBkPa+pTkPa);
yT=pTkPa/(pBkPa+pTkPa);

//Since the total pressure is only 42.305 kN/m 2 , then with a total pressure of 101.3 kN/m 2 , the liquid will not vaporise unless the pressure is decreased.

end Ex11_3;
//===============
