//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.5 Page 551
//Title:  Dew point of the mixture
//======================================================

model Ex11_5
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real kB[3]={6.90565,1211.033,220.79}" Antoine constants for Benzene";
parameter Real kT[3]={6.95334,1343.943,219.377}" Antoine constants for Toluene";
parameter Real Pt(unit="kPa")=101.3 " Pressure";
parameter Real T[5](each unit="K")={373.2,371.2,371.7,371.9,372} " Temperature ranges ";

//=============
// Variable Section

Real pB[5] (each unit="mm Hg")" Saturated vapour pressure of Benzene";
Real pT[5] (each unit="mm Hg")" Saturated vapour pressure of Toluene";
Real pBkPa[5] (each unit="kPa")" Saturated vapour pressure of Benzene in kPa";
Real pTkPa[5] (each unit="kPa")" Saturated vapour pressure of Toluene in kPa";
Real Sumx[5]  " Total mole fraction";
Real Tfinal(unit="K") " Boiling point of the mixture";

//=============
// Equation Section

equation

for i in 1:5 loop

log10(pB[i])=kB[1]-(kB[2]/(kB[3]+T[i]-273.15));
log10(pT[i])=kT[1]-(kT[2]/(kT[3]+T[i]-273.15));
pBkPa[i]=(pB[i]/760)*101.325;
pTkPa[i]=(pT[i]/760)*101.325;
Sumx[i]=(0.5*Pt)*((1/pBkPa[i])+(1/pTkPa[i]));

end for;

Tfinal=T[5]; // Taken as Sumx approximately equal to 1

end Ex11_5;
//===============
