//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-12: Absorption of Gases
//Example: 12.1 Page 669
//Title:  Mass transfer coefficients
//======================================================

model Ex12_1

//=============
// Parameter Section
 
parameter Real T(unit="K")=273 " Temperature";
parameter Real KLa(unit="kmol/sm^3 (kmol/m^3)")=0.003" Overall liquid transfer coefficient";
parameter Real D[2](each unit="cm^2/s")={0.103,0.17} " Diffusivities of SO2 and NH3";
parameter Real H(unit="(kN/m^2)/(kmol/m^3)")=50 " Henry's Law Constant";

//=============
// Variable Section

Real kLa(unit="kmol/sm^3 (kmol/m^3)") " Liquid phase coefficient";
Real kGaSO2 (unit="kmol/sm^3 (kN/m^2)") " Gas phase coefficient of SO2";
Real kGaNH3 (unit="kmol/sm^3 (kN/m^2)") " Gas phase coefficient of NH3";
Real KGaNH3 (unit="kmol/sm^3 (kN/m^2)") " Overall Gas phase coefficient of NH3";

//=============
// Equation Section

equation

(1/KLa)=(2/kLa);
kGaSO2=kLa/H;
kGaNH3=kGaSO2*((D[2]/D[1])^0.56);
KGaNH3=kGaNH3;//For a very soluble gas such as NH3, they are equal

end Ex12_1;
//===============
