//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-12: Absorption of Gases
//Example: 12.5 Page 700
//Title:  Necessary Height of Tower
//======================================================

model Ex12_5
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real G(unit="kg/s m^2")=0.95" Gas flow rate";
parameter Real L(unit="kg/s m^2")=0.65" Liquid flow rate";
parameter Real y1=0.1 " Mole fraction of gas at bottom of tower";
parameter Real y2=0.001 " Mole fraction of gas at bottom of tower";
parameter Real x1=0.013 " Mole fraction of liquid at bottom of tower";
parameter Real Kga( unit="kmol/s m^3")=0.001 " Mass transfer coefficient";
parameter Real molratio[7](each unit="kmol NH3/kmol water")={0.021,0.031,0.042,0.053,0.079,0.106,0.159} " Mole ratio of NH3 to water";
parameter Real PP[7](each unit="mm Hg")={12,18.2,24.9,31.7,50,69.6,114} " Partial pressure";
parameter Real Plmtd(unit="kPa")=0.688 " Log mean Pressure ";

//=============
// Variable Section

Real Y1 " Mole fraction";
Real mpa " Mass percent of air";
Real Lm (unit="kmol/m^2 s") " Molar liquid flow rate";
Real Gm (unit="kmol/m^2 s") " Molar gas flow rate";
Real Y[7] " Mole fraction";
Real AUC " Area under the curve";
Real Z1 (unit="m") " Height";
Real Z2 (unit="m") " Height of tower";

//=============
// Equation Section

equation

Y1=y1/(1-y1);
mpa=((0.9*29)/((0.1*17) + (0.9*29)))*100;
Gm=(mpa/100)*G/29;
Lm=L/18;

for i in 1:7 loop
Y[i]=PP[i]/(760-PP[i]);
end for;

AUC=12.6;

Z1=(Gm/(y2*101.325))*AUC;
Z2=Gm*0.11/(y2*Plmtd);

end Ex12_5;
//===============
