//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-12: Absorption of Gases
//Example: 12.6 Page 708
//Title:  Number of plates
//======================================================

model Ex12_6

//=============
// Parameter Section
 
parameter Real X2=0.06 " Inlet oil composition";
parameter Real X1=0.001 " Mole ratio of pentane in oil";
parameter Real Pact=30 " Number of plates in bubble cap column";
parameter Real n=30 " Overall plate efficiency";
parameter Real A1=1.37" Value of 1/A for actual";

//=============
// Variable Section

Real Ye2 " Equilibrium mole fraction";
Real GLmin " Gas to liquid ratio minimum";
Real GLact " Gas to liquid ratio actual";
Real GLact2 " Gas to liquid ratio actual in 2nd case";
Real NTP " Number of theoretical plates";
Real A12 " Value of 1/A in 2nd case";
Real Ratio " Ratio of actual to minimum for 9 plates";
Real N (start=1)" Theoretical number of plates for ratio of 2";
Real Nact " Actual number of plates for ratio of 2";

//=============
// Equation Section

equation

Ye2=3*X2;
NTP=Pact*n/100;
GLmin=(X2-X1)/Ye2;
GLact*3=A1;
Ratio=GLact/GLmin;
GLact2=2*GLmin;
A12=3*GLact2;
(X2-X1)/X2=((A12)^(N+1)-A12)/((A12)^(N+1)-1);
Nact=(N/n)*100;

end Ex12_6;
//===============
