//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-13: Liquid-liquid extraction
//Example: 13.4 Page 754
//Title:   Surface mean droplet size
//======================================================

model Ex13_4

//=============
// Parameter Section
 
parameter Real d[5](each unit="mm")={2,3,4,5,6} " Diameter of droplets";
parameter Real n[5]={30,120,200,80,20} " Number of droplets";

//=============
// Variable Section

Real snd3 (unit="mm^3") " Sum of n*d^3";
Real snd2 (unit="mm^3") " Sum of n*d^2";
Real ds (unit="mm") " Surface mean size";

//=============
// Equation Section

algorithm

snd3:=0;
snd2:=0;

for i in 1:5 loop
snd3:=n[i]*d[i]^3+snd3;
snd2:=n[i]*d[i]^2+snd2;
end for;

equation

ds=snd3/snd2;

end Ex13_4;
//===============
