//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-13: Liquid-liquid extraction
//Example: 13.5 Page 758
//Title: NTU and Overall extraction coefficient
//======================================================

model Ex13_5
extends Modelica.Constants;
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real L(unit="m")=3 " Length";
parameter Real D(unit="m")=75e-3 " Diameter";

parameter Real CSA(unit="m^2")=0.0045 " Cross Sectional area";
parameter Real eth(unit="kg/m^2s")=0.5 " Flow of ether";
parameter Real aci(unit="kg/m^2s")=0.25 " Flow of acid";

parameter Real Cr2(unit="kg/kg")=0.04 " Acid concentration in inlet";
parameter Real Cr1(unit="kg/kg")=0.01 " Acid concentration in outlet";


//=============
// Variable Section

Real area(unit="m^2") " Area";
Real volume(unit="m^3") " Volume";
Real mat(unit="kg/s") " Mass of acid transferred to ether";
Real af(unit="kg/m^3 s") " Acid in aqueous feed";
Real ar (unit="kg/m^2 s") " Acid in raffinate";
Real dC[2](each unit="kg/kg") " Driving force";
Real dClm(unit="kg/kg") " Log mean Driving force";
Real KRa(unit="kg/s m^3(kg/kg)")" Mass transfer coefficient";
Real NTU " Number of overall transfer units";
Real H(unit="m") " Height of overall transfer unit";

//=============
// Equation Section

equation

area=(pi/4)*D*D;
volume=area*L;
mat=area*eth*Cr1;
af=aci*Cr2;
ar=af-0.005;
dC[2]=(Cr2*0.3)-0.01;
dC[1]=0.02*0.3;
dClm=(dC[2]-dC[1])/log(dC[2]/dC[1]);
KRa=mat/(volume*dClm);
H=aci/KRa;
NTU=L/H;

end Ex13_5;
//===============
