//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.1 Page 779
//Title:   Heating surface area required
//======================================================

model Ex14_1

//=============
// Parameter Section
 
parameter Real U(unit="kW/m^2K")=3 " Overall Heat transfer coefficient";
parameter Real Cp[2](each unit="kJ/kg K")={3.76,3.14} " Specific heat capacity";
parameter Real Sp(unit="kPa")=205 " Steam Pressure";
parameter Real P(unit="kPa")=13.5 " Evaporation Pressure";
parameter Real m(unit="kg/s")=7 " Solution flow rate";
parameter Real Tdat(unit="K")=273 " Datum temperature";
parameter Real Te[2](each unit="K")={294,352.5} " Inlet and outlet temperature for evaporator";

// Assuming dry steam at 205kPa
parameter Real Ts1(unit="K")=394 " Steam temperature";
parameter Real H1(unit="kJ/kg")=2530 " Steam total enthalpy";

// Steam at 13.5kPa
parameter Real Ts2(unit="K")=325 " Steam temperature";
parameter Real H2(unit="kJ/kg")=2594 " Steam total enthalpy";

//=============
// Variable Section

Real x (unit="kg/s")" mass of water";
Real ms (unit="kg/s")" Mass of dry solids";
Real me (unit="kg/s") " Mass of solids evaporated";
Real Hf(unit="kW") " Heat entering the feed";
Real Hp(unit="kW") " Heat leaving the product";
Real He(unit="kW") " Heat leaving with evaporated water";
Real Hs(unit="kW") " Heat transferred with steam ";
Real Hcs(unit="kW") " Enthalpy of condensed feed";
Real Hs1(unit="kW") " Heat transferred from 1 kg steam";
Real S(unit="kg/s") " Amount of steam required";
Real dT(unit="K") " Temperature difference";
Real A(unit="m^2") " Area of the evaporator required";

//=============
// Equation Section

equation

ms=m*0.1;
(ms*100)/(ms+x)=50;
me=m-ms-x;
Hf= m*Cp[1]*(Te[1]-Tdat);
Hp=(x+ms)*Cp[2]*(Ts2-Tdat);
He=me*H2;
Hs=He+Hp-Hf;
Hcs=4.186*(Te[2]-Tdat);
Hs1=H1-Hcs;
S=Hs/Hs1;
dT=Ts1-Ts2;
Hs=U*A*dT;

end Ex14_1;
//===============
