//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.4 Page 795
//Title:  Additional Steam requirement
//======================================================

model Ex14_4

//=============
// Parameter Section
 
parameter Real P[2](each unit="kPa")={101.3,120} " Pressure in and out";
parameter Real H[2](each unit="kJ/kg")={2780,2375} " Enthalpy from chart";
parameter Real BPR(unit="K") =1.1" Boiling point rise";
parameter Real Ti(unit="K") =344" Inlet steam temperature";
parameter Real r =1.3"Gamma Value";

//=============
// Variable Section

Real Gx(unit="kg/s",start=0.015) " Additional steam inlet";
Real Gy(unit="kg/s") " Water feed";
Real E (unit="kW")" Actual power supplied to the compressor";
Real E1 (unit="kW")" Work done by the compressor";
Real p1(unit="kg/m^3") " Density";
Real V1(unit="m^3") " Volume";

//=============
// Equation Section

equation

Gx+(0.5*Gy)=0.125;
E+ (2761*Gx) + (296.8*Gy)= (211.3*Gy)+54.9;
p1=(18/22.4)*(273/(373+BPR));
V1=0.5*Gy/p1;
E1*(0.5*Gy)=((P[1]*V1)/(r-1)) *(((P[2]/P[1])^((r-1)/r)) - 1);
E=23*Gy;


end Ex14_4;
//===============
