//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.1 Page 836
//Title:  Supersaturation ratio
//======================================================

model Ex15_1

//=============
// Parameter Section
 
parameter Real c(unit="kg sucrose/kg water")=2.45" Supersaturated concentration";
parameter Real c1(unit="kg sucrose/kg water")=2.04" Equilibrium concentration";

//=============
// Variable Section

Real S " Supersaturation ratio";
Real Ss " Supersaturation ratio in terms of solution";
Real cs(unit="kg sucrose/kg solution") " Supersaturated concentration for solution";
Real c1s(unit="kg sucrose/kg solution") " Equilibrium concentration for solution";

//=============
// Equation Section

equation

S=c/c1;
Ss=cs/c1s;
cs=c/(c+1);
c1s=c1/(c1+1);

end Ex15_1;
//===============
