//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.5- Page 855
//Title:   Length of crystalliser
//======================================================

model Ex15_5
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real Th[2](each unit="K")={313,298} " Inlet and Outlet Temperature of solution";
parameter Real Tc[2](each unit="K")={288,293} " Inlet and Outlet Temperature of cooling water";
parameter Real c1(unit="kg /kg water")=0.3" Initial Concentration";
parameter Real c2(unit="kg /kg water")=0.155" Final Concentration";
parameter Real w1(unit="kg/s")=0.77 "  Initial mass";
parameter Real Cp(unit="kJ/kg K")=3.2 " Heat capacity of solution";
parameter Real m[2](each unit="kg/kmol")={164,380}" Relative molecular mass ";
parameter Real U(unit="W/m^2 K")=140 " Heat transfer coefficient";
parameter Real hc(unit="kJ/kg")=146.5 " Mean heat of crystallisation";

//=============
// Variable Section

Real R " Ratio";
Real mrate(unit="kg/s") " Required feed rate";
Real y (unit="kg") " Yield ";
Real Qc(unit="kW") " Heat required to cool the solution";
Real Qh(unit="kW") " Heat of crystallisation";
Real Tlmtd(unit="K") " Log mean temperature Difference";
Real A(unit="m^2") " Area required";
Real L(unit="m") " Length required";

//=============
// Equation Section

equation

R=m[2]/m[1];
y=(w1*R) *(c1-c2)/(1-c2*(R-1));
mrate=0.063/y;
Qc=mrate*Cp*(Th[1]-Th[2]);
Qh=0.063*hc;
Tlmtd=((Th[1]-Tc[2])-(Th[2]-Tc[1]))/log((Th[1]-Tc[2])/(Th[2]-Tc[1]));
A=(Qh+Qc)*1000/(U*Tlmtd);
L=A;// Assuming that the area available is  1 m^2/m length

end Ex15_5;
//===============
