//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-16: Drying
//Example: 16.2- Page 909
//Title:  Time to dry
//======================================================

model Ex16_2

//=============
// Parameter Section
 
parameter Real t[2](each unit="mm")={10,60}" Thickness";
parameter Real t1(unit="ks")=25" Time";
parameter Real W1[2](each unit="kg/kg")={0.28,0.13}" Initial and Final moisture content of 10mm plank";
parameter Real W2[2](each unit="kg/kg")={0.22,0.10}" Initial and Final moisture content of 60mm plank";
parameter Real We(unit="kg/kg")=0.07 " Equilibrium moisture content";
parameter Real E[7]= {1 ,0.64, 0.49 ,0.38 ,0.295 ,0.22, 0.14}" Value of E";
parameter Real J[7]={0, 0.1 ,0.2 ,0.3 ,0.5 ,0.6, 0.7}" Parameter J";
parameter Real J1=0.52 " Value of J at E=0.286";
parameter Real J2=0.63 " Value of J at E=0.2";

//=============
// Variable Section

Real t2(unit="ks") " Time to dry 60 mm plank";
Real k " Constant k";
Real E1 " Value of E for 1st plank";
Real E2 " Value of E for 2nd plank";
Real X1[2] (each unit="kg/kg")" Free moisture content for plank 1";
Real X2[2] (each unit="kg/kg")" Free moisture content for plank 2";

//=============
// Equation Section

equation

X1[1]=W1[1]-We;
X1[2]=W1[2]-We;
X2[1]=W2[1]-We;
X2[2]=W2[2]-We;
E1=X1[2]/X1[1];
E2=X2[2]/X2[1];
J1=k*t1/(t[1]/2)^2;
J2=k*t2/(t[2]/2)^2;

end Ex16_2;
//===============
