//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-16: Drying
//Example: 16.5- Page 930
//Title:  Diameter & Length of dryer
//======================================================

model Ex16_5
extends Modelica.Math;
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real per[2]={15,0.5}" Initial and final percent moisture";
parameter Real m(unit="kg/s")=0.35" Flow of solids";
parameter Real Cp(unit="kJ/kgK")=2.2 " Mean heat capacity of the solids";
parameter Real H1(unit="kg/kg")=0.01 " Maximum allowable humidity";
parameter Real umax(unit="kg/m^2 s") =0.95 " Maximum allowable mass velocity";
parameter Real Tair(unit="K")=400 " Temperature of air";
parameter Real T[2](each unit="K")={300,325} " Temperature of inlet and outlet";
parameter Real Twb(unit="K")=312 " Temperature of wet bulb";

//Properties from steam tables
parameter Real LHvap(unit="kJ/kg")=2410 " Latent heat of vaporisation";
parameter Real Cpv(each unit="kJ/kg K")=1.88 " Specific heat of vapour ,material";

//=============
// Variable Section

Real Tad(unit="K") " Adiabatic temperature";
Real mwe(unit="kg/s") " Mass of water evaporated";
Real Q(unit="kW") " Total heat duty";
Real G1(unit="kg/s") " Mass flowrate of inlet air";
Real Ga(unit="kg/s") " Mass flowrate of dry air";
Real H2(unit="kg/kg") " Outlet humidity";
Real D(unit="m") " Diameter of dryer";
Real L(unit="m") " Length of dryer";
Real Tlmtd(unit="K") " Log-mean temperature difference";
Real a(unit="m^2") " Area of the dryer";

//=============
// Equation Section

equation

mwe=m*1e-2*(per[1]-per[2]);
1.5=log((Tair-Twb)/(Tad-Twb));
Q=m*(  (Cp*(T[2]-T[1])) + (per[1]*1e-2*4.186*(Twb-T[1])) + (LHvap*1e-2*(per[1]-per[2])) +((T[2]-Twb)*4.186*per[2]/100) +  ((Tad-Twb)*Cpv*(per[1]-per[2])/100) );
G1*(1+H1)=Q/(1.03*(Tair-Tad));
Ga=G1/(1+H1);
H2=H1+(mwe/Ga);
a=G1/umax;
a=(pi/4)*(D^2);
Tlmtd=((Tair-Twb)-(Tad-Twb))/log((Tair-Twb)/(Tad-Twb));
L=Q/(0.0625*pi*D*(umax^0.67)*Tlmtd);

end Ex16_5;
//===============
