//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-17: Adsorption
//Example: 17.1 Page 986
//Title:   Estimates of surface area
//======================================================

model Ex17_1
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real d(unit="nm")=15 " Diameter";
parameter Real p1[2](each unit="kg/m^3")={2290,808} " Density of particle and liquid nitrogen";
parameter Real a(unit="nm^2")=0.162 " Area occupied by one adsorbed molecule of nitrogen";
parameter Real pp[9]={0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9} " P/Po values";
parameter Real mk[9](each unit="m^3 liq Nitrogen/kg adsorbed") ={66.7,75.2,83.9,93.4,108.4,130,150.2,202,348} " Volume adsorbed per unit mass";
parameter Real Bslope(unit="kg/m^3") =13902" Slope of BET isotherm";
parameter Real Bint(unit="kg/m^3") =300" Intercept of BET isotherm";
parameter Real Lslope(unit="kg/m^3") =13902 " Slope of Langmuir isotherm";


//=============
// Variable Section

Real ss (unit="m^2/kg") " Specific surface area";
Real B " Value of B from BET isotherm";
Real V1 (unit="m^3/kg") " Value of V from BET isotherm"; 
Real V2 (unit="m^3/kg") " Value of V from Langmuir isotherm"; 
Real tsa (unit="m^2/kg") " Total surface area";

//=============
// Equation Section

equation

ss=6/((d*1e-9)*p1[1]);
1/(V1*B)=Bint;
(B-1)/(V1*B)=Bslope;
1/V2=Lslope;
tsa=(V1*p1[2]*N_A*1e3*a*1e-18)/28;

end Ex17_1;
//===============
