//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-17: Adsorption
//Example: 17.3 Page 1015 
//Title:  Length of the bed
//======================================================

model Ex17_3
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real d(unit="m")=0.15 " Diameter";
parameter Real V(unit="m^3/s")=1e-4" Volumetric flow rate";
parameter Real E=0.4 " Intergranular voidage";
parameter Real t(unit="s")=3600 " Time";
parameter Real Co(unit="kmol/m^3")=0.03 " Concentration";

//=============
// Variable Section

Real u (unit="m/s") " Velocity";
Real m " Value of m";
Real z[3] (each unit="m") " Length of the bed";
Real sat " Saturation percentage at breakpoint";
//=============
// Equation Section

equation

u=V/(pi*d*d*E/4);
m=E/(1-E);
z[1]= (u*t)/(1+(10/m));
z[2]= (u*t)/(1+((1/m)*(3/Co^0.7)));
z[3]= (u*t)/(1+(60/m));
sat=(100*u*t)/(z[3]*(1+(9/(Co*m))));

end Ex17_3;
//===============
