//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-17: Adsorption
//Example: 17.5 Page 1031
//Title:   Moving bed adsorption design
//======================================================

model Ex17_5

//=============
// Parameter Section

parameter Real kpaz(unit="kg/m^3 s") =0.964 " Solid film coefficient for pellet diffusion";
parameter Real E =0.47" Voidage";
parameter Real uc(unit="m/s") =6.2e-6 " Velocity";
parameter Real p1p(unit="kg/m^3") =1266 " Density of particle";
parameter Real G(unit="kg/m^2 s") =0.129 " Gas Flow rate";
parameter Real N =10.95 " Number of units";

//=============
// Variable Section

Real m " Constant m";
Real m1 " Slope m1";
Real ta(unit="hour") " Time for adsorption";
Real t(unit="hour") " Time required";
Real kgaz(unit="kg/m^3 s") " Film coefficient";
Real kg0az(unit="kg/m^3 s") " Film coefficient";
Real Gs1 (unit="kg/m^2 s") " Adsorption wave movement";
Real Gs2 (unit="kg/m^2 s") " Rate of travel";
Real L(unit="m") " Length of adsorption zone";

//=============
// Equation Section

equation

m=E/(1-E);
Gs1=uc*(1-E)*p1p;
Gs2*(0.084-0)=0.129*(0.00267);
ta=8.3;
m1=0.00267/0.084;
kgaz=31.48*(G^0.55);
kg0az=7.64;
L=N*G/kg0az;
t=4.4;

end Ex17_5;
//===============
