//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-2: Particle size reduction and enlargement
//Example: 2.1 Page 101
//Title:  Consumption of energy
//======================================================

model Ex2_1
extends Modelica.Math; 

//=============
// Parameter Section
 
parameter Real L1[2](each unit="mm") ={50,10} " Initial & Final Size of particle in 1st case";
parameter Real E(unit="kW/(kg/s)") =13 " Energy consumption required to crush from 50 to 10 mm";
parameter Real L2[2](each unit="mm") ={75,25} " Initial & Final Size of particle in 2nd case";

//=============
// Variable Section

Real Krfc(unit="kW/(kg mm)") " Constant for Rittinger's Law";
Real Kkfc(unit="kW/(kg s)") " Constant for Kick's Law";
Real Er(unit="kJ/kg") " Energy required to crush in Rittinger's Law";
Real Ek(unit="kJ/kg") " Energy required to crush in Kick's Law";

//=============
// Equation Section

equation

E=Krfc*( (1/L1[2])-(1/L1[1]) );
E=Kkfc*log((L1[1]/L1[2]));
Er=Krfc*( (1/L2[2])-(1/L2[1]) );
Ek=Kkfc*log((L2[1]/L2[2]));


end Ex2_1;
//===============
