//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-2: Particle size reduction and enlargement
//Example: 2.2 Page 116
//Title:  Maximum size of particle to be fed
//======================================================

model Ex2_2
extends Modelica.Math;
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real D(unit = "m") = 1 " Diameter of roll";
parameter Real d(unit = "m") = 12.5e-3 " Distance between crushing rolls";
parameter Real percent = 12 " Percentage capacity";
parameter Real f(unit = "Hz") = 2 " Frequency";
parameter Real d1(unit = "kg/m^3") = 2500 " Density";
parameter Real L(unit = "m") = 0.4 " Length of working face of roll";
parameter Real a(unit = "degrees") = 31 " Angle of nip";
  
//=============
// Variable Section
  
Real r2(unit = "m") " Maximum size of the particle";
Real A(unit = "m^2") " Cross Sectional Area";
Real V(unit = "m^3/s") " Volumetric Flow rate";
Real Vr(unit = "m^3/s") " Actual Volumetric Flow rate";
Real m(unit = "kg/s") " Mass Flow rate";
  
//=============
// Equation Section

equation

cos(pi/180*(a/2)) = (D/2 + d/2)/(r2 + D/2);
A=d*L;
V=A*f;
Vr=V*percent/100;
m=Vr*d1;

end Ex2_2;
//===============
