//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-2: Particle size reduction and enlargement
//Example: 2.3 Page 129
//Title:  Modifications in Ball Mill
//======================================================

model Ex2_3
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real D(unit = "m") = 1.2 " Diameter of ball mill";
parameter Real f(unit = "Hz") = 0.8 " Frequency";

//=============
// Variable Section

Real wa(unit = "rad/s") " Actual speed";
Real wc(unit = "rad/s") " Critical speed";
Real wo(unit = "rad/s") " Optimum speed";
Real fo(unit = "Hz") " Optimum frequency";

//=============
// Equation Section

equation
  
wa = 2 * pi * f;
wc = (g_n / (D / 2)) ^ 0.5;
wo = 0.6 * wc;
fo = wo / (2 * pi);
  
//Thus the speed of rotation must be halved.

end Ex2_3;
//===============
