//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-3: Motion of particles in a fluid
//Example: 3.2 Page 159
//Title:  Percentage Of Galena carried away
//======================================================

model Ex3_2
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real D(unit="m")=100e-6 " Diameter of the largest particle";
parameter Real v1(unit="Pa s")=1e-3 " Viscosity of water";
parameter Real p1(unit="kg/m^3")=1000 " Density of water";
parameter Real p1l(unit="kg/m^3")=2700 " Density of limestone";
parameter Real p1g(unit="kg/m^3")=7500 " Density of galena";
parameter Real u(unit="m/s")=5e-3 " Water flow velocity";
parameter Real F(unit="m/s")=100 " Feed quantity (basis)";

//=============
// Variable Section

Real Re" Reynolds Number";
Real dl(unit="m") " Size of limestone particle removed by water";
Real dg(unit="m") " Size of galena particle removed by water";
Real Fg(unit="kg") " Amount of galena in feed";
Real Fl(unit="kg") " Amount of limestone in feed";
Real Gremoved(unit="kg") " Amount of Galena removed";
Real Lremoved(unit="kg") " Amount of Limestone removed";
Real Gremaining(unit="kg") " Amount of Galena remaining";
Real Lremaining(unit="kg") " Amount of Galena remaining";
Real Gconc[2]" Percentage galena removed and remaining repsectively";

//=============
// Equation Section

equation

Re=D*u*p1/v1;
dl=((18*u*v1)/(g_n*(p1l-p1)))^0.5;
dg=((18*u*v1)/(g_n*(p1g-p1)))^0.5;
Fg=0.2*F;
Fl=0.8*F;
Gremoved=0.2*F*0.43;   //From interpolation of data
Lremoved=0.8*F*0.74;   //From interpolation of data
Gremaining=Fg-Gremoved;
Lremaining=Fl-Lremoved;
Gconc[1]= (Gremoved*F)/(Gremoved+Lremoved);
Gconc[2]= (Gremaining*F)/(Gremaining+Lremaining);

end Ex3_2;
//===============
