//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-3: Motion of particles in a fluid
//Example: 3.3 Page 167
//Title:  Terminal Velocities of Mica
//======================================================

model Ex3_3
extends Modelica.Constants;
extends Modelica.Math;

//=============
// Parameter Section

parameter Real D(unit="m")=1e-3 " Diameter";
parameter Real v1(unit="Pa s")=10e-3 " Viscosity of oil";
parameter Real p1(unit="kg/m^3")=820 " Density of oil";
parameter Real p1m(unit="kg/m^3")=3000 " Density of Mica";
parameter Real A[2](each unit="m^2")={6e-6,600e-6} " Area range"; 
parameter Real k[2]={0.285,0.0285} " Constant K";
parameter Real LogRe[2]={1.581 , 2.857} " Value of Log Re";
parameter Real cor[2]={-0.038,-0.300 }" Correction factors";

//=============
// Variable Section

//Indices 1 and 2 indicate smallest and largest particles respectively
Real dp[2] (each unit="m")" Value of dp";
Real LogR [2]" Value of R/pu^2*Re^2";
Real Re[2] " Corrected Reynolds Number";
Real uo[2] " Terminal velocity";

//=============
// Equation Section

equation

for i in 1:2 loop

(pi*dp[i]^2)/4=A[i];
LogR[i]=((4*k[i])/(pi*v1*v1))*(p1m-p1)*(p1*dp[i]^3*g_n);
log10(Re[i])=(LogRe[i]+cor[i]);
Re[i]=dp[i]*uo[i]*p1/v1;

end for;

end Ex3_3;
//===============
