//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-3: Motion of particles in a fluid
//Example: 3.4 Page 181
//Title:  Distance travelled by the particle
//======================================================

model Ex3_4
extends Modelica.Constants;
extends Modelica.Math;

//=============
// Parameter Section

parameter Real dp(unit="m")=6e-3 " Diameter";
parameter Real v1(unit="Pa s")=1e-3 " Viscosity of water";
parameter Real p1p(unit="kg/m^3")=2500 " Density of material";
parameter Real p1(unit="kg/m^3")=1000 " Density of water";
parameter Real ur(unit="m/s")=1.2 " Upward rising velocity";
parameter Real ud(unit="m/s")=6 " Velocity";

//=============
// Variable Section

Real Re " Reynolds number";
Real ymin(unit="m/s") " Minimum value of velocity";
Real c1 " Constant c";
Real f " Constant f";
Real a " Constant a";
Real b" Constant b";
Real y1 (unit="m") " Distance moved by the particle";
Real y2 (unit="m") " Distance moved by fluid";
Real yt (unit="m") " Total distance moved ";
Real t1(unit="s") " Time 1";
Real t2(unit="s") " Time 2";

//=============
// Equation Section

equation

Re=(ud-ur)*p1*dp/v1;
ymin=(ud-ur)*500/Re;
c1=(1/(3*dp))*(p1/p1p);
f=sqrt((3*dp*(p1p-p1)*g_n)/p1);
a=18*v1/((dp^2)*p1p);
b=(1-(p1/p1p))*g_n;
b/a=29.51*e^(-0.02*t1);
y1=(b/a)*t1- (29.51/0.2)*(1-e^(t1*0.02));
cos(11.37*t2)=0.264;
y2=t2*ur;
yt=y2+0.102;

end Ex3_4;
//===============
