//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-3: Motion of particles in a fluid
//Example: 3.5 Page 183
//Title:  Maximum size of particle
//======================================================

model Ex3_5
extends Modelica.Constants;
extends Modelica.Math;

//=============
// Parameter Section

parameter Real D(unit="m")=3 " Depth of liquid";
parameter Real v1(unit="Pa s")=2e-3 " Viscosity of liquid";
parameter Real p1p(unit="kg/m^3")=2350 " Density of salt";
parameter Real p1(unit="kg/m^3")=1100 " Density of liquid";

//=============
// Variable Section

Real u(unit="m/s") " Velocity";
Real d(unit="m") " Diameter of particle";
Real C1 " Constant C1";
Real C2 " Constant C2";

//=============
// Equation Section

equation 

u=g_n*d*d*(p1p-p1)/(18*v1);
C1=3e-6;
C2=68.1;
d=6e-4 +((2.1e-4)*atan(4.76e3*d));

end Ex3_5;
