//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-5: Sedimentation
//Example: 5.3 Page 275
//Title:  Maximum Flux and concentration
//======================================================

model Ex5_3
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real d(unit="m")=1e-4 " Diameter";
parameter Real v1(unit="Pa s")=1e-3 " Kinematic Viscosity";
parameter Real p1(unit="kg/m^3")=1000 " Water density";
parameter Real p1g(unit="kg/m^3")=2600 " Glass density";

//=============
// Variable Section

Real C " Concentration";
Real w1max(unit="m^3/m^2 s") " Maximum Flux";
Real uo(unit="m/s") " Terminal settling velocity";

//=============
// Equation Section

equation

uo=g_n*d^2*(p1g-p1)/(18*v1);
-4.8*C+(1-C)=0;
w1max=C*((1-C)^4.8)*uo;

end Ex5_3;
//===============
