//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-6: Fluidisation
//Example: 6.2 Page 299 
//Title:  Fluidisation and transport of particles
//======================================================

model Ex6_2
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real d(unit="m")=1e-4 " Diameter";
parameter Real v1(unit="Pa s")=3e-3 " Kinematic Viscosity";
parameter Real p1(unit="kg/m^3")=900 " Oil density";
parameter Real p1p(unit="kg/m^3")=2600 " Particle density";

//=============
// Variable Section

Real Gmf[2](each unit="kg/m^2s") " Mass flow rate per unuit area for fluidisation and transport of particles respectively";
Real Re " Reynolds No";
Real uo (unit="m/s")" Terminal Falling velocity";
Real e " Voidage";
Real umf(unit="m/s") " Minimum fluidisation velocity";

//=============
// Equation Section

equation

e=((8*(d^3))-8*((pi/6)*(d^3)))/(8*(d^3));
umf=0.0055*((e^3)/(1-e))*((g_n*(d^2)*(p1p-p1))/v1);
Gmf[1]=p1*umf;
uo=g_n*d*d*(p1p-p1)/(18*v1);
Re=d*uo*p1/v1;
Gmf[2]=p1*uo;

end Ex6_2;
//===============
