//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-6: Fluidisation
//Example: 6.3 Page 305
//Title:  Voidage of bed
//======================================================

model Ex6_3
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real d(unit="m")=4e-3 " Diameter";
parameter Real u (unit="m/s")=0.25" Velocity";
parameter Real v1(unit="Pa s")=1e-3 " Kinematic Viscosity";
parameter Real p1(unit="kg/m^3")=1000 " Water density";
parameter Real p1p(unit="kg/m^3")=2500 " Glass Particle density";

//=============
// Variable Section

Real Ga " Galileo Number";
Real Re " Reynolds No";
Real uo(unit="m/s") " Terminal falling velocity";
Real e " Voidage";
Real n " Value of n from eqn.6.32 from page 303";

//=============
// Equation Section

equation

Ga=((d^3)*p1*(p1p-p1)*g_n)/(v1^2);
Re=((2.33*(Ga^0.018))-(1.53*Ga^(-0.016)))^13.3;
Re=uo*d*p1/v1;
(4.8-n)/(n-2.4)=0.043*(Ga^0.57);
u/uo=e^n;

end Ex6_3;
//===============
