//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.5 Page 424
//Title:  Optimum filtration time 
//======================================================
  
model Ex7_5

//=============
// Parameter Section

parameter Real t[2](each unit="s")={300,600} " Leaf filter time";
parameter Real A1(unit="m^2")=2.2 " Area of plate and frame filter";
parameter Real A2(unit="m^2")=0.05 " Area of small leaf filter";
parameter Real V[2](each unit="m^3")={0.00025,0.00040} " Volume collected";
parameter Real td(unit="s")=21600 " Downtime";
parameter Real Fcost(unit="Great British Pound/s")=10e-3 " Filtration cost";
parameter Real Scost(unit="Great British Pound")=100 " Shutdown cost";
parameter Real P1(unit="kPa")=413 " Pressure in plate and frame filter";
parameter Real P2(unit="kPa")=70 " Pressure in leaf filter";

//=============
// Variable Section

Real ruL  (unit="Ns/m^3")" Constant ruL";
Real ruv (unit="Ns/m^4")" Constant ruv";
Real B1 (unit="s/m^6")" Constant B1";
Real B2 (unit="s/m^3")" Constant B2";
Real t1(unit="s") " Filtration time for maximum throughput ";
Real V1(unit="m^3") " Volume collected ";
Real rate(unit="m^3/s") " Mean rate of filtration ";
Real Opt_time(unit="s") " Optimum filtration time for minimum cost ";

//=============
// Equation Section

equation

t[1]/V[1]=(ruv*V[1]/(2*A2*A2*P2*1e3)) + (ruL/(A2*P2*1e3));
t[2]/V[2]=(ruv*V[2]/(2*A2*A2*P2*1e3)) + (ruL/(A2*P2*1e3));
B1=ruv/(2*A1*A1*P1*1e3);
B2=ruL/(2*A1*P1*1e3);
t1=td+(B2*(td/B1)^0.5);
V1=(td/B1)^0.5;
rate=V1/(t1+td);
Opt_time=(Scost/Fcost)+(B2*(100/((0.01*B1)^0.5)));

//There is a variation in the final answer because the value of the second time to collect filtrate is taken as 400s in the book instead of 600s as given in the question. Thus, the constant ruv also has a different solution and value of B1 also changes. Thus the optimum time is slightly more than that given in the book.

end Ex7_5;
//===============
