//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-9: Centrifugal Separations
//Example: 9.1 Page 482
//Title:  Capacity Factor
//======================================================

model Ex9_1
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real d1(unit="m")=5e-6 " Diameter";
parameter Real Q1(unit="m^3/s")=0.25 " Flow rate of water";
parameter Real Q2(unit="m^3/s")=0.04 " Flow rate of oil";
parameter Real v1(unit="Pa s")=1e-3 " Viscosity";
parameter Real v1oil(unit="Pa s")=1e-2 " Oil Viscosity";
parameter Real p1(unit="kg/m^3")=1000 " Water density";
parameter Real p1p(unit="kg/m^3")=2800 " Mineral density";
parameter Real p1oil(unit="kg/m^3")=850 " Oil density";
parameter Real p1coal(unit="kg/m^3")=1300 " Coal density";

//=============
// Variable Section

Real uo[2](each unit="m/s") " Terminal Settling Velocity in water and oil system respectively";
Real Sigma(unit="m^2") " Capacity Factor";
Real d2(unit="m") " Size in coal suspension";

//=============
// Equation Section

equation

uo[1]=(d1^2)*g_n*(p1p-p1)/(18*v1);
Q1=uo[1]*Sigma;
Q2=uo[2]*Sigma;
d2=(18*v1oil*uo[2]/((p1coal-p1oil)*g_n))^0.5;

//Answer of d2 obtained is incorrect. The actual answer is 1.2e-5 metre

end Ex9_1;
//===============
