//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.4 Page 39
//Title:  Minimum apparent density of the fluid
//======================================================

model Ex1_4
extends Modelica.Math; 

//=============
// Parameter Section
 
parameter Real p1g(unit="kg/m^3") =7500" Density of galena";
parameter Real p1q(unit="kg/m^3") =2650" Density of quartz";
parameter Real d[2](each unit="mm")={0.015,0.065} " Size Range"; 

//=============
// Variable Section

Real p1l[2](each unit="kg/m^3") " Density of liquid in Stokes and Newton's Regime respectively";

//=============
// Equation Section

equation

d[2]/d[1]=((p1g-p1l[1])/(p1q-p1l[1]))^0.5;
d[2]/d[1]=((p1g-p1l[2])/(p1q-p1l[2]));

end Ex1_4;
//===============
