//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.6 Page 71
//Title:  Overall efficiency of collector
//======================================================

model Ex1_6
extends Modelica.Math; 

//=============
// Parameter Section
 
parameter Real basis(unit="m^3") =1" Basis volume of gas";
parameter Real n[6](each unit="") ={20,40,80,90,95,100} " Efficiency(per cent) for 6 size ranges ";
parameter Real m[6](each unit="")={10,15,35,20,10,10} " Mass percent for size ranges"; 
parameter Real db(unit="g/m^3")=18 " Dust burden at entry";
parameter Real Q(unit="m^3/s")=0.3 " Gas flow rate";

//=============
// Variable Section

Real mi[6](each unit="g") " Mass inlet";
Real me[6](each unit="g") " Mass emitted";
Real met(unit="g") " Total mass emitted";
Real mrt(unit="g") " Total mass retained";
Real mr[6](each unit="g") " Mass retained";
Real n_ovr" Overall Efficiency";
Real n_20" Efficiency less than 20micrometre";
Real mf(unit="kg/s") " Mass flow of emitted gas";

//=============
// Equation Section

equation

for i in 1:6 loop
mi[i]=db*m[i]/100;
mr[i]=mi[i]*n[i]/100;
me[i]=mi[i]-mr[i];
end for;
n_ovr=100*mrt/db;
n_20=100*(me[1]+me[2]+me[3])/met;//To consider less than 20 micro metre we consider first 3 values
mf=Q*met*1e-3;

algorithm

for i in 1:6 loop
met:=met+me[i];
mrt:=mrt+mr[i];
end for;

end Ex1_6;
//===============
