//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-10: Leaching
//Example: 10.1 Page 506
//Title:  Time to dissolve
//======================================================

model Ex10_1
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real cs(unit="kg/m^3")=2.5 " Saturated concentration";
parameter Real V[2](each unit="m^3")={1,100} " Volume";
parameter Real t(unit="s")=10 " Time";

//=============
// Variable Section

Real con[2](each unit="kg/m^3") " Concentration in pilot plant and full scale vessel ";
Real kAb(unit="m^3/s") " Value of kA/b";
Real t1(unit="s",start=0) " Time";

//=============
// Equation Section

equation

con[1]=cs*0.75;
con[1]=cs*(1-e^(-(kAb/V[1])*t));
con[2]=(500*0.28)/V[2];
con[2]=cs*(1-e^(-(kAb/V[2])*t1));

end Ex10_1;
//===============
